/*
 Navicat Premium Dump SQL

 Source Server         : ubuntu24.04_mysql8.0
 Source Server Type    : MySQL
 Source Server Version : 80043 (8.0.43-0ubuntu0.24.04.1)
 Source Host           : 172.18.248.230:3306
 Source Schema         : eim

 Target Server Type    : MySQL
 Target Server Version : 80043 (8.0.43-0ubuntu0.24.04.1)
 File Encoding         : 65001

 Date: 15/08/2025 11:40:34
*/

USE eim;
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for addcode
-- ----------------------------
DROP TABLE IF EXISTS `addcode`;
CREATE TABLE `addcode`  (
  `userid` int NOT NULL DEFAULT 0,
  `addcode` int NULL DEFAULT NULL,
  `serialnumber` int NULL DEFAULT NULL,
  PRIMARY KEY (`userid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of addcode
-- ----------------------------

-- ----------------------------
-- Table structure for company
-- ----------------------------
DROP TABLE IF EXISTS `company`;
CREATE TABLE `company`  (
  `companyid` int NOT NULL DEFAULT 0,
  `caption` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `createdate` datetime NULL DEFAULT NULL,
  `othersyseidkey` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `voipuserid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `voipps` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`companyid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of company
-- ----------------------------
INSERT INTO `company` VALUES (1, 'AI公司', NULL, '1000', NULL, NULL);

-- ----------------------------
-- Table structure for dbcon
-- ----------------------------
DROP TABLE IF EXISTS `dbcon`;
CREATE TABLE `dbcon`  (
  `id` int NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dbcon
-- ----------------------------

-- ----------------------------
-- Table structure for dept
-- ----------------------------
DROP TABLE IF EXISTS `dept`;
CREATE TABLE `dept`  (
  `deptid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '',
  `superid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `companyid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `sortnum` int NULL DEFAULT NULL,
  `caption` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`deptid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of dept
-- ----------------------------
INSERT INTO `dept` VALUES ('1', '0', '1', 2, '研发部门');
INSERT INTO `dept` VALUES ('10', '1', '1', 2, '前端开发部');
INSERT INTO `dept` VALUES ('12', '1', '1', 4, '运维部');
INSERT INTO `dept` VALUES ('13', '', '1', 3, 'AI策划部');
INSERT INTO `dept` VALUES ('2', '1', '1', 1, '测试部门');
INSERT INTO `dept` VALUES ('3', '0', '1', 3, '营销部门');
INSERT INTO `dept` VALUES ('4', '3', '1', 1, '营销一部');
INSERT INTO `dept` VALUES ('5', '3', '1', 2, '营销二部');
INSERT INTO `dept` VALUES ('6', '3', '1', 3, '营销三部');
INSERT INTO `dept` VALUES ('7', '3', '1', 4, '营销四部');
INSERT INTO `dept` VALUES ('8', '3', '1', 5, '营销五部');
INSERT INTO `dept` VALUES ('9', '1', '1', 1, '后端开发部');

-- ----------------------------
-- Table structure for deptemp
-- ----------------------------
DROP TABLE IF EXISTS `deptemp`;
CREATE TABLE `deptemp`  (
  `deptid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '',
  `userid` int NOT NULL DEFAULT 0,
  `companyid` int NOT NULL DEFAULT 0,
  `sortnum` int NULL DEFAULT NULL,
  PRIMARY KEY (`deptid`, `userid`, `companyid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of deptemp
-- ----------------------------
INSERT INTO `deptemp` VALUES ('1', 4, 1, 0);
INSERT INTO `deptemp` VALUES ('1', 5, 1, 0);
INSERT INTO `deptemp` VALUES ('13', 10, 1, 0);
INSERT INTO `deptemp` VALUES ('2', 1, 1, 0);
INSERT INTO `deptemp` VALUES ('2', 2, 1, 0);
INSERT INTO `deptemp` VALUES ('2', 3, 1, 0);
INSERT INTO `deptemp` VALUES ('2', 9, 1, 0);
INSERT INTO `deptemp` VALUES ('2', 11, 1, 0);
INSERT INTO `deptemp` VALUES ('4', 6, 1, 0);
INSERT INTO `deptemp` VALUES ('4', 7, 1, 0);
INSERT INTO `deptemp` VALUES ('4', 8, 1, 0);

-- ----------------------------
-- Table structure for emp_analyse
-- ----------------------------
DROP TABLE IF EXISTS `emp_analyse`;
CREATE TABLE `emp_analyse`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `userid` int NULL DEFAULT NULL,
  `onlinetime` int NULL DEFAULT NULL,
  `logincount` int NULL DEFAULT NULL,
  `dropcount` int NULL DEFAULT NULL,
  `logindate` datetime NULL DEFAULT NULL,
  `offlinedate` datetime NULL DEFAULT NULL,
  `realname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `companyid` int NULL DEFAULT NULL,
  `diffzone` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of emp_analyse
-- ----------------------------

-- ----------------------------
-- Table structure for emp_face_del
-- ----------------------------
DROP TABLE IF EXISTS `emp_face_del`;
CREATE TABLE `emp_face_del`  (
  `faceid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`faceid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of emp_face_del
-- ----------------------------

-- ----------------------------
-- Table structure for emp_role
-- ----------------------------
DROP TABLE IF EXISTS `emp_role`;
CREATE TABLE `emp_role`  (
  `userid` int NOT NULL DEFAULT 0,
  `roleid` int NOT NULL DEFAULT 0,
  `companyid` int NOT NULL DEFAULT 0,
  PRIMARY KEY (`userid`, `roleid`, `companyid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of emp_role
-- ----------------------------
INSERT INTO `emp_role` VALUES (1, 1, 1);
INSERT INTO `emp_role` VALUES (2, 1, 1);
INSERT INTO `emp_role` VALUES (3, 1, 1);
INSERT INTO `emp_role` VALUES (4, 1, 1);
INSERT INTO `emp_role` VALUES (5, 1, 1);
INSERT INTO `emp_role` VALUES (6, 1, 1);
INSERT INTO `emp_role` VALUES (7, 1, 1);
INSERT INTO `emp_role` VALUES (8, 1, 1);

-- ----------------------------
-- Table structure for employee
-- ----------------------------
DROP TABLE IF EXISTS `employee`;
CREATE TABLE `employee`  (
  `userid` int NOT NULL DEFAULT 0,
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `workcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `realname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `sex` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `birthday` datetime NULL DEFAULT NULL,
  `faceid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `duty` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `telphone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `mail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `fax` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `age` int NULL DEFAULT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `linkaddress` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `zipcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `country` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `province` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `city` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `bloodtype` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `createtime` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`userid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of employee
-- ----------------------------
INSERT INTO `employee` VALUES (1, 'test1', '3649F86809FF2E750747B043D46EDF98', '', '测试1', '', '2025-07-08 00:00:00', '619D8DE6E6CD425DA8AFC33BC33F4021.png', '', '', '', '', '', 0, '', '', '', '', '', '', '', '', '2025-06-15 15:53:21');
INSERT INTO `employee` VALUES (2, 'test3', '3649F86809FF2E750747B043D46EDF98', '', '测试3', '', NULL, NULL, '', '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-06-15 15:53:38');
INSERT INTO `employee` VALUES (3, 'test2', '3649F86809FF2E750747B043D46EDF98', '', '测试2', '', NULL, NULL, '', '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-06-15 15:54:02');
INSERT INTO `employee` VALUES (4, 'zbs', '3649F86809FF2E750747B043D46EDF98', '', '张博士', '', NULL, NULL, '', '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-06-15 15:55:50');
INSERT INTO `employee` VALUES (5, 'lbs', '3649F86809FF2E750747B043D46EDF98', '', '李博士', '', NULL, NULL, '', '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-06-15 15:56:04');
INSERT INTO `employee` VALUES (6, 'yx1', '3649F86809FF2E750747B043D46EDF98', '', '营销员1', '', NULL, NULL, '', '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-06-27 08:18:52');
INSERT INTO `employee` VALUES (7, 'yx2', '3649F86809FF2E750747B043D46EDF98', '', '营销员2', '', NULL, NULL, '', '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-06-27 08:19:09');
INSERT INTO `employee` VALUES (8, 'yx3', '3649F86809FF2E750747B043D46EDF98', '', '营销员3', '', NULL, NULL, '', '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-06-27 08:19:24');
INSERT INTO `employee` VALUES (9, 'test4', '3649F86809FF2E750747B043D46EDF98', '', '测试4', '', NULL, NULL, '', '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-12 10:06:28');
INSERT INTO `employee` VALUES (10, 'ai', '3649F86809FF2E750747B043D46EDF98', '', '机器人1', '', NULL, NULL, '', '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-12 10:05:04');
INSERT INTO `employee` VALUES (11, 'test5', '3649F86809FF2E750747B043D46EDF98', '', '测试5', '', NULL, NULL, '', '', '', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-08-12 10:04:01');

-- ----------------------------
-- Table structure for global_value
-- ----------------------------
DROP TABLE IF EXISTS `global_value`;
CREATE TABLE `global_value`  (
  `id` int NOT NULL DEFAULT 0,
  `keyvalue` int NULL DEFAULT NULL,
  `typeid` int NULL DEFAULT NULL,
  `caption` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of global_value
-- ----------------------------
INSERT INTO `global_value` VALUES (1, 11, 1, '用户');
INSERT INTO `global_value` VALUES (2, 0, 2, '公司');
INSERT INTO `global_value` VALUES (3, 13, 3, '部门');
INSERT INTO `global_value` VALUES (4, 207, 4, '视图节点');
INSERT INTO `global_value` VALUES (5, 1, 5, '角色');
INSERT INTO `global_value` VALUES (6, 21, 6, '权限明细');
INSERT INTO `global_value` VALUES (7, 0, 7, NULL);
INSERT INTO `global_value` VALUES (8, 0, 8, '头像');
INSERT INTO `global_value` VALUES (9, 0, 9, 'MSN记录');

-- ----------------------------
-- Table structure for integrate
-- ----------------------------
DROP TABLE IF EXISTS `integrate`;
CREATE TABLE `integrate`  (
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '',
  `caption` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `picname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `display` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `companyid` int NULL DEFAULT NULL,
  `deptid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `createtime` datetime NULL DEFAULT NULL,
  `sortnumber` int NULL DEFAULT NULL,
  `messagestyleid` int NULL DEFAULT NULL,
  PRIMARY KEY (`guid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of integrate
-- ----------------------------

-- ----------------------------
-- Table structure for manager_user
-- ----------------------------
DROP TABLE IF EXISTS `manager_user`;
CREATE TABLE `manager_user`  (
  `id` int NOT NULL DEFAULT 0,
  `logname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `realname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `roleid` int NULL DEFAULT NULL,
  `companyid` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of manager_user
-- ----------------------------
INSERT INTO `manager_user` VALUES (1, 'admin', 'C4CA4238A0B923820DCC509A6F75849B', 'admin', 0, 0);
INSERT INTO `manager_user` VALUES (2, 'admin', 'C4CA4238A0B923820DCC509A6F75849B', 'admin', 0, 1);

-- ----------------------------
-- Table structure for msgmonitor
-- ----------------------------
DROP TABLE IF EXISTS `msgmonitor`;
CREATE TABLE `msgmonitor`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `msgid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `msgname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `msgcontent` varchar(3000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `msgfontinfo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `msgtype` int NULL DEFAULT NULL,
  `senduserid` int NULL DEFAULT NULL,
  `sendusername` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `revuserid` int NULL DEFAULT NULL,
  `revusername` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `msgtime` datetime NULL DEFAULT NULL,
  `createtime` datetime NULL DEFAULT NULL,
  `companyid` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of msgmonitor
-- ----------------------------

-- ----------------------------
-- Table structure for msn
-- ----------------------------
DROP TABLE IF EXISTS `msn`;
CREATE TABLE `msn`  (
  `id` int NOT NULL DEFAULT 0,
  `messagemail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `recmail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `messagecontent` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `messagedatetime` datetime NULL DEFAULT NULL,
  `messagetype` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of msn
-- ----------------------------

-- ----------------------------
-- Table structure for offlinemessage_content
-- ----------------------------
DROP TABLE IF EXISTS `offlinemessage_content`;
CREATE TABLE `offlinemessage_content`  (
  `msgid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '',
  `content` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `createtime` datetime NULL DEFAULT NULL,
  `orderid` int NULL DEFAULT NULL,
  PRIMARY KEY (`msgid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of offlinemessage_content
-- ----------------------------
INSERT INTO `offlinemessage_content` VALUES ('12DD3980682941C6BA20D5C155DD9349', 'CHAT 0\r\n{\"CBY\":{\"ST\":45827.4028522685,\"SD\":\"1\",\"ID\":\"2F80DF7F652B49BB82306BCC1C3C913B\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"5555\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"12DD3980682941C6BA20D5C155DD9349\"}\r\n', '2025-06-19 09:40:06', 3);
INSERT INTO `offlinemessage_content` VALUES ('1B656E67B6544182BDA66D720EC449B1', 'CHAT 0\r\n{\"CBY\":{\"ST\":45827.2453115972,\"SD\":\"1\",\"ID\":\"98530BD32F5B4F3B9BF0AC30087521F5\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"99\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"1B656E67B6544182BDA66D720EC449B1\"}\r\n', '2025-06-19 05:53:14', 2);
INSERT INTO `offlinemessage_content` VALUES ('270C0D5057C844EFB1519221FCD75A40', 'GroupChatMessage 0\r\n{\"_MSGSND\":\"1\",\"CBY\":{\"_MSGID\":\"D7E4C7B46E2C46CAA8C992FC7F6D2D62\",\"ST\":45837.3786007986,\"SD\":\"1\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"FT\":{\"sz\":12,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"u963fu65afu987fu53d1u5c71u4e1c\",\"SDTN\":\"u6d4bu8bd51\",\"Name\":\"u901au77e5\"},\"_MSGID\":\"270C0D5057C844EFB1519221FCD75A40\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"From\":\"1\"}\r\n', '2025-06-29 09:05:11', 0);
INSERT INTO `offlinemessage_content` VALUES ('4CF8376A995F4FD7ADFDE5055E007B97', 'CHAT 0\r\n{\"CBY\":{\"ST\":45833.0669210648,\"SD\":\"1\",\"ID\":\"8291B2E71BBC4BC884B89D6AF39E6CE0\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"u4f60u597duff01\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"4CF8376A995F4FD7ADFDE5055E007B97\"}\r\n', '2025-06-25 01:36:21', 7);
INSERT INTO `offlinemessage_content` VALUES ('55FFBF7461FC447FA4679F4C081A71D3', 'CHAT 0\r\n{\"CBY\":{\"ST\":45831.4031925,\"SD\":\"1\",\"ID\":\"0886AAA445D942BEB3AECB27E039E112\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"/p:202506237D5702F74A2246AB935739647C30DE07.jpg@1;;;\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"55FFBF7461FC447FA4679F4C081A71D3\"}\r\n', '2025-06-23 09:40:35', 6);
INSERT INTO `offlinemessage_content` VALUES ('64A0FE8289A342208C61CC936B89AE0E', 'CHAT 0\r\n{\"CBY\":{\"ST\":45827.4040517708,\"SD\":\"1\",\"ID\":\"95DCD50FDE134A20928FE442DD271E1F\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"33232\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"64A0FE8289A342208C61CC936B89AE0E\"}\r\n', '2025-06-19 09:41:50', 5);
INSERT INTO `offlinemessage_content` VALUES ('721E39002FBE44AF893E461D685E2F3E', 'CHAT 0\r\n{\"CBY\":{\"ST\":45827.4044815741,\"SD\":\"1\",\"ID\":\"7A2657C1FF494628843DD550C74094B7\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"34532\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"721E39002FBE44AF893E461D685E2F3E\"}\r\n', '2025-06-19 09:42:27', 7);
INSERT INTO `offlinemessage_content` VALUES ('87C2AC47A526444EABDEFB1FDCFB0AB9', 'CHAT 0\r\n{\"CBY\":{\"ST\":45827.4040049306,\"SD\":\"1\",\"ID\":\"6F65AC20685A419F9431EF4D43590DD7\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"1111\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"87C2AC47A526444EABDEFB1FDCFB0AB9\"}\r\n', '2025-06-19 09:41:46', 4);
INSERT INTO `offlinemessage_content` VALUES ('A107815C5BCC48B0B9C58FA1DA5985B0', 'GroupChatMessage 0\r\n{\"_MSGSND\":\"1\",\"CBY\":{\"_MSGID\":\"A2E616491E35437A857750D7E3D92434\",\"ST\":45837.378628287,\"SD\":\"1\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"FT\":{\"sz\":12,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"u5bf9u7684u6492u53d1u7684\",\"SDTN\":\"u6d4bu8bd51\",\"Name\":\"u901au77e5\"},\"_MSGID\":\"A107815C5BCC48B0B9C58FA1DA5985B0\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"From\":\"1\"}\r\n', '2025-06-29 09:05:13', 1);
INSERT INTO `offlinemessage_content` VALUES ('A85F0105749C488FB34057E909ED55BA', 'CHAT 0\r\n{\"CBY\":{\"ST\":45827.4044360069,\"SD\":\"1\",\"ID\":\"98043D611C834B92B8A083A2AA057936\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"11111\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"A85F0105749C488FB34057E909ED55BA\"}\r\n', '2025-06-19 09:42:23', 6);
INSERT INTO `offlinemessage_content` VALUES ('AC2BA410E33C4383A162B03DF58F9907', 'GroupChatMessage 0\r\n{\"_MSGSND\":\"3\",\"CBY\":{\"_MSGID\":\"D9945ABA1815453C90AAFB83E4268B58\",\"ST\":45838.1250708333,\"SD\":\"3\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"FT\":{\"sz\":12,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"121212\",\"SDTN\":\"u6d4bu8bd52\",\"Name\":\"u8463u4e8bu4f1au6d88u606fu7fa4\"},\"_MSGID\":\"AC2BA410E33C4383A162B03DF58F9907\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"From\":\"3\"}\r\n', '2025-06-30 03:00:06', 3);
INSERT INTO `offlinemessage_content` VALUES ('B37D613D10004F319A3CAC582A2DB167', 'CHAT 0\r\n{\"CBY\":{\"ST\":45836.4369106134,\"SD\":\"2\",\"ID\":\"21C610CAAE4B4AB0A530CFF53382B67C\",\"FT\":{\"sz\":11,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"u4f60u597duff01u5f00u4f1au901au77e5u3002u4e0bu5348u4e24u70b9u3002\",\"SDTN\":\"u6d4bu8bd53\"},\"_MSGID\":\"B37D613D10004F319A3CAC582A2DB167\"}\r\n', '2025-06-28 10:29:09', 2);
INSERT INTO `offlinemessage_content` VALUES ('B466B4617DC1482EB889C732540387FD', 'CHAT 0\r\n{\"CBY\":{\"ST\":45827.4079915046,\"SD\":\"1\",\"ID\":\"E53A74B0C3894E90BB136F1749080938\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"444\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"B466B4617DC1482EB889C732540387FD\"}\r\n', '2025-06-19 09:47:30', 11);
INSERT INTO `offlinemessage_content` VALUES ('B7AF7ED98B1142CD8E979B578E4ADE12', 'CHAT 0\r\n{\"CBY\":{\"ST\":45827.4079388773,\"SD\":\"1\",\"ID\":\"1F36497229D44827BDDE11A26CA6F798\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"111\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"B7AF7ED98B1142CD8E979B578E4ADE12\"}\r\n', '2025-06-19 09:47:25', 10);
INSERT INTO `offlinemessage_content` VALUES ('BDBEB0E6061846E792D9E039A0D85F7E', 'GroupChatMessage 0\r\n{\"_MSGSND\":\"3\",\"CBY\":{\"_MSGID\":\"33C746676E944EFFBDF157EF2FC7C19C\",\"ST\":45838.1282521875,\"SD\":\"3\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"FT\":{\"sz\":12,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"121212\",\"SDTN\":\"u6d4bu8bd52\",\"Name\":\"u8463u4e8bu4f1au6d88u606fu7fa4\"},\"_MSGID\":\"BDBEB0E6061846E792D9E039A0D85F7E\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"From\":\"3\"}\r\n', '2025-06-30 03:04:41', 4);
INSERT INTO `offlinemessage_content` VALUES ('D8B68F0A2DC940F296670EB35D0B38CF', 'CHAT 0\r\n{\"CBY\":{\"ST\":45833.0669832755,\"SD\":\"1\",\"ID\":\"C9944509C3644652A20E52668F432D09\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"u6d4bu8bd5u4ebau5458\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"D8B68F0A2DC940F296670EB35D0B38CF\"}\r\n', '2025-06-25 01:36:27', 8);
INSERT INTO `offlinemessage_content` VALUES ('DC1A136856874990B3A6E13371A29F81', 'GroupChatMessage 0\r\n{\"_MSGSND\":\"3\",\"CBY\":{\"_MSGID\":\"7F315A28557A4298BC6C554A6A949AF3\",\"ST\":45838.1282955903,\"SD\":\"3\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"FT\":{\"sz\":12,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"u554au98d2u98d2\",\"SDTN\":\"u6d4bu8bd52\",\"Name\":\"u8463u4e8bu4f1au6d88u606fu7fa4\"},\"_MSGID\":\"DC1A136856874990B3A6E13371A29F81\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"From\":\"3\"}\r\n', '2025-06-30 03:04:44', 5);
INSERT INTO `offlinemessage_content` VALUES ('EBD6300C5A91475E8361E254DA7E0F9C', 'CHAT 0\r\n{\"CBY\":{\"ST\":45831.4029176157,\"SD\":\"1\",\"ID\":\"5E10EAEA5D9347508CAD25B73ADEE363\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"u4e0du5728u529eu516cu5ba4uff0cu6709u4e8bu60c5u627euff0cu8bf7u6253u7535u8bddu6216u53d1u77edu4fe1uff01\",\"SDTN\":\"u6d4bu8bd51\",\"RVTN\":\"u5f20u535au58eb\",\"RUID\":4},\"_MSGID\":\"EBD6300C5A91475E8361E254DA7E0F9C\"}\r\n', '2025-06-23 09:40:12', 5);
INSERT INTO `offlinemessage_content` VALUES ('F7690F8380CB439BB5F719512A4DCAF9', 'CHAT 0\r\n{\"CBY\":{\"ST\":45862.3975831944,\"SD\":\"3\",\"ID\":\"CF959BC62DEB4D13875AD420A2D03448\",\"FT\":{\"sz\":9,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"/f:/qiang;;;\",\"SDTN\":\"u6d4bu8bd52\",\"RVTN\":\"u6d4bu8bd53\",\"RUID\":2},\"_MSGID\":\"F7690F8380CB439BB5F719512A4DCAF9\"}\r\n', '2025-07-24 09:32:31', 0);
INSERT INTO `offlinemessage_content` VALUES ('FFBDA9862F4B461581213C2F5A8FE805', 'GroupChatMessage 0\r\n{\"_MSGSND\":\"3\",\"CBY\":{\"_MSGID\":\"6577C86933CE4E3B86371F57FB080AC9\",\"ST\":45838.1233391319,\"SD\":\"3\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"FT\":{\"sz\":12,\"nm\":\"u5b8bu4f53\",\"cl\":-16777208},\"CT\":\"/p:202506308E47B0B4E3E04CC9864942652423D8B4.jpg;;;\",\"SDTN\":\"u6d4bu8bd52\",\"Name\":\"u8463u4e8bu4f1au6d88u606fu7fa4\"},\"_MSGID\":\"FFBDA9862F4B461581213C2F5A8FE805\",\"ID\":\"74EB01E1FE684E56B5E283601A2ECE3F\",\"From\":\"3\"}\r\n', '2025-06-30 02:57:36', 2);

-- ----------------------------
-- Table structure for offlinemessage_relation
-- ----------------------------
DROP TABLE IF EXISTS `offlinemessage_relation`;
CREATE TABLE `offlinemessage_relation`  (
  `msgid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '',
  `userid` int NOT NULL DEFAULT 0,
  `flag` int NULL DEFAULT NULL,
  PRIMARY KEY (`msgid`, `userid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of offlinemessage_relation
-- ----------------------------
INSERT INTO `offlinemessage_relation` VALUES ('12DD3980682941C6BA20D5C155DD9349', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('1B656E67B6544182BDA66D720EC449B1', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('270C0D5057C844EFB1519221FCD75A40', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('270C0D5057C844EFB1519221FCD75A40', 5, 0);
INSERT INTO `offlinemessage_relation` VALUES ('4CF8376A995F4FD7ADFDE5055E007B97', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('55FFBF7461FC447FA4679F4C081A71D3', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('64A0FE8289A342208C61CC936B89AE0E', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('721E39002FBE44AF893E461D685E2F3E', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('87C2AC47A526444EABDEFB1FDCFB0AB9', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('A107815C5BCC48B0B9C58FA1DA5985B0', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('A107815C5BCC48B0B9C58FA1DA5985B0', 5, 0);
INSERT INTO `offlinemessage_relation` VALUES ('A85F0105749C488FB34057E909ED55BA', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('AC2BA410E33C4383A162B03DF58F9907', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('AC2BA410E33C4383A162B03DF58F9907', 5, 0);
INSERT INTO `offlinemessage_relation` VALUES ('B37D613D10004F319A3CAC582A2DB167', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('B37D613D10004F319A3CAC582A2DB167', 7, 0);
INSERT INTO `offlinemessage_relation` VALUES ('B37D613D10004F319A3CAC582A2DB167', 8, 0);
INSERT INTO `offlinemessage_relation` VALUES ('B466B4617DC1482EB889C732540387FD', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('B7AF7ED98B1142CD8E979B578E4ADE12', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('BDBEB0E6061846E792D9E039A0D85F7E', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('BDBEB0E6061846E792D9E039A0D85F7E', 5, 0);
INSERT INTO `offlinemessage_relation` VALUES ('D8B68F0A2DC940F296670EB35D0B38CF', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('DC1A136856874990B3A6E13371A29F81', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('DC1A136856874990B3A6E13371A29F81', 5, 0);
INSERT INTO `offlinemessage_relation` VALUES ('EBD6300C5A91475E8361E254DA7E0F9C', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('F7690F8380CB439BB5F719512A4DCAF9', 2, 0);
INSERT INTO `offlinemessage_relation` VALUES ('FFBDA9862F4B461581213C2F5A8FE805', 4, 0);
INSERT INTO `offlinemessage_relation` VALUES ('FFBDA9862F4B461581213C2F5A8FE805', 5, 0);

-- ----------------------------
-- Table structure for reginfo
-- ----------------------------
DROP TABLE IF EXISTS `reginfo`;
CREATE TABLE `reginfo`  (
  `id` int NOT NULL DEFAULT 0,
  `daycount` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `rtype` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `rcount` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `rchecktype` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `rtag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `rcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `rname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of reginfo
-- ----------------------------
INSERT INTO `reginfo` VALUES (1, 'd/8stQ==', 'cw==', 'caWciho=', 'cw==', 'BzmQidHGgLnWE4g8PkS/jz3m2LRths3Uh7aXYX/aijA=', 'caS0ahX6XNk49PXsgcHbkA==', 'hEnF20W8ARM=');

-- ----------------------------
-- Table structure for rights
-- ----------------------------
DROP TABLE IF EXISTS `rights`;
CREATE TABLE `rights`  (
  `rightid` int NOT NULL DEFAULT 0,
  `caption` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `companyid` int NULL DEFAULT NULL,
  `sortnumber` int NULL DEFAULT NULL,
  `des` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`rightid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of rights
-- ----------------------------
INSERT INTO `rights` VALUES (1, '文件共享', 0, 1, '该权限允许用户可以将自己的信息共享给别人，可以指定文件共享权限，设置共享人员的黑名单和白名单');
INSERT INTO `rights` VALUES (2, '点对点音频', 0, 2, '该权限允许用户发起两人之间的音频对话，音频对话具体为通过麦克和耳机，借助网络传输音频数据，直接和对方进行沟通');
INSERT INTO `rights` VALUES (3, '点对点视频', 0, 3, '该权限允许用户发起两人之间的视频对话，视频对话具体为通过麦克和耳机和摄像头，借助网络传输音频和音频数据，直接和对方进行面对面沟通');
INSERT INTO `rights` VALUES (4, '文件传输', 0, 4, '该权限允许用户是否允许用户使用文件在线传输功能');
INSERT INTO `rights` VALUES (5, '群发文件', 0, 5, '该权限允许用户是否可以对多个人进行发送');
INSERT INTO `rights` VALUES (6, '群发消息', 0, 6, '该权限允许用户是否可以对多个人进行消息发送');
INSERT INTO `rights` VALUES (7, '远程协助', 0, 7, '该权限允许用户是否可以使用远程控制功能');
INSERT INTO `rights` VALUES (8, '修改密码', 0, 8, '该权限允许用户是否可以修改自己的密码');
INSERT INTO `rights` VALUES (9, '修改个人信息', 0, 9, '该权限允许用户是否可以修改个人的资料信息');
INSERT INTO `rights` VALUES (10, '修改头像', 0, 10, '该权限允许用户是否可以修改自己头像');
INSERT INTO `rights` VALUES (11, '创建群组', 0, 11, '该权限允许用户在对方不在线给对方发送文件的功能，用户上线后能够接收文件');
INSERT INTO `rights` VALUES (12, '离线文件传输', 0, 12, '该权限允许用户是否可以对不在线的人进行群发限制');
INSERT INTO `rights` VALUES (13, '群发离线文件', 0, 13, '该权限允许用户是否可以对不在线的人进行群发离线文件限制');
INSERT INTO `rights` VALUES (30, '短信发送', 0, 30, '该权限允许用户是否进行短信发送');
INSERT INTO `rights` VALUES (31, '传真发送', 0, 31, '该权限允许用户是否进行传真发送');
INSERT INTO `rights` VALUES (32, 'USB电话', 0, 32, '该权限允许用户是否进行USB电话拨打');
INSERT INTO `rights` VALUES (33, '网络电话', 0, 33, '该权限允许用户是否进行网络电话拨打');
INSERT INTO `rights` VALUES (34, '多方语音', 0, 34, '该权限允许用户是否进行多方语音电话');
INSERT INTO `rights` VALUES (35, 'TTS语音', 0, 35, '该权限允许用户是否进行TTS语音发送');
INSERT INTO `rights` VALUES (36, '电子邮件', 0, 36, '该权限允许用户是否进行电子邮件发送');

-- ----------------------------
-- Table structure for role
-- ----------------------------
DROP TABLE IF EXISTS `role`;
CREATE TABLE `role`  (
  `roleid` int NOT NULL DEFAULT 0,
  `caption` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `companyid` int NULL DEFAULT NULL,
  `des` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`roleid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of role
-- ----------------------------
INSERT INTO `role` VALUES (1, '管理员', 1, '');

-- ----------------------------
-- Table structure for role_limit
-- ----------------------------
DROP TABLE IF EXISTS `role_limit`;
CREATE TABLE `role_limit`  (
  `id` int NOT NULL DEFAULT 0,
  `roleid` int NULL DEFAULT NULL,
  `rvalue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `companyid` int NULL DEFAULT NULL,
  `type` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of role_limit
-- ----------------------------
INSERT INTO `role_limit` VALUES (11, 1, 'SingleFileSize:50', 1, 0);
INSERT INTO `role_limit` VALUES (12, 1, 'OffileFileSize:50', 1, 0);
INSERT INTO `role_limit` VALUES (13, 1, 'GroupFileSize:50', 1, 0);
INSERT INTO `role_limit` VALUES (14, 1, 'GroupMsgRecvCount:50', 1, 0);
INSERT INTO `role_limit` VALUES (15, 1, 'GroupFileRecvCount:50', 1, 0);
INSERT INTO `role_limit` VALUES (16, 1, 'Keys_GroupCreateCount:50', 1, 0);
INSERT INTO `role_limit` VALUES (17, 1, 'GroupSendSmsCount:50', 1, 0);
INSERT INTO `role_limit` VALUES (18, 1, 'GroupSendFaxCount:50', 1, 0);
INSERT INTO `role_limit` VALUES (19, 1, 'GroupSendMeetCount:50', 1, 0);
INSERT INTO `role_limit` VALUES (20, 1, 'GroupSendTTSCount:50', 1, 0);
INSERT INTO `role_limit` VALUES (21, 1, 'GroupSendMailCount:50', 1, 0);

-- ----------------------------
-- Table structure for role_right
-- ----------------------------
DROP TABLE IF EXISTS `role_right`;
CREATE TABLE `role_right`  (
  `roleid` int NOT NULL DEFAULT 0,
  `rightid` int NOT NULL DEFAULT 0,
  `companyid` int NOT NULL DEFAULT 0,
  PRIMARY KEY (`roleid`, `rightid`, `companyid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of role_right
-- ----------------------------
INSERT INTO `role_right` VALUES (1, 1, 1);
INSERT INTO `role_right` VALUES (1, 2, 1);
INSERT INTO `role_right` VALUES (1, 3, 1);
INSERT INTO `role_right` VALUES (1, 4, 1);
INSERT INTO `role_right` VALUES (1, 5, 1);
INSERT INTO `role_right` VALUES (1, 6, 1);
INSERT INTO `role_right` VALUES (1, 7, 1);
INSERT INTO `role_right` VALUES (1, 8, 1);
INSERT INTO `role_right` VALUES (1, 9, 1);
INSERT INTO `role_right` VALUES (1, 10, 1);
INSERT INTO `role_right` VALUES (1, 11, 1);
INSERT INTO `role_right` VALUES (1, 12, 1);
INSERT INTO `role_right` VALUES (1, 13, 1);
INSERT INTO `role_right` VALUES (1, 30, 1);
INSERT INTO `role_right` VALUES (1, 31, 1);
INSERT INTO `role_right` VALUES (1, 32, 1);
INSERT INTO `role_right` VALUES (1, 33, 1);
INSERT INTO `role_right` VALUES (1, 34, 1);
INSERT INTO `role_right` VALUES (1, 35, 1);
INSERT INTO `role_right` VALUES (1, 36, 1);

-- ----------------------------
-- Table structure for updatetag
-- ----------------------------
DROP TABLE IF EXISTS `updatetag`;
CREATE TABLE `updatetag`  (
  `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tag`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of updatetag
-- ----------------------------

-- ----------------------------
-- Table structure for video
-- ----------------------------
DROP TABLE IF EXISTS `video`;
CREATE TABLE `video`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `confid` int NULL DEFAULT NULL,
  `senderid` int NULL DEFAULT NULL,
  `realname` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `begintime` datetime NULL DEFAULT NULL,
  `endtime` datetime NULL DEFAULT NULL,
  `joinsum` int NULL DEFAULT NULL,
  `users` varchar(5000) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `userpwd` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `chairpwd` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `videotype` int NULL DEFAULT NULL,
  `notifytag` int NULL DEFAULT NULL,
  `companyid` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of video
-- ----------------------------

-- ----------------------------
-- Table structure for view_info
-- ----------------------------
DROP TABLE IF EXISTS `view_info`;
CREATE TABLE `view_info`  (
  `viewid` int NOT NULL DEFAULT 0,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `caption` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `defaultright` int NULL DEFAULT NULL,
  `companyid` int NULL DEFAULT NULL,
  PRIMARY KEY (`viewid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of view_info
-- ----------------------------

-- ----------------------------
-- Table structure for view_node
-- ----------------------------
DROP TABLE IF EXISTS `view_node`;
CREATE TABLE `view_node`  (
  `nodeid` int NOT NULL DEFAULT 0,
  `nodetype` int NULL DEFAULT NULL,
  `nodedataid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  `viewid` int NULL DEFAULT NULL,
  `companyid` int NULL DEFAULT NULL,
  `tag` int NULL DEFAULT NULL,
  PRIMARY KEY (`nodeid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of view_node
-- ----------------------------

-- ----------------------------
-- Table structure for view_ref
-- ----------------------------
DROP TABLE IF EXISTS `view_ref`;
CREATE TABLE `view_ref`  (
  `nodeid` int NOT NULL DEFAULT 0,
  `parentnodeid` int NULL DEFAULT NULL,
  `viewid` int NULL DEFAULT NULL,
  `sortnum` int NULL DEFAULT NULL,
  `caption` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NULL DEFAULT NULL,
  PRIMARY KEY (`nodeid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of view_ref
-- ----------------------------

-- ----------------------------
-- Table structure for view_user
-- ----------------------------
DROP TABLE IF EXISTS `view_user`;
CREATE TABLE `view_user`  (
  `viewid` int NOT NULL,
  `userid` int NOT NULL,
  `userright` int NULL DEFAULT NULL,
  PRIMARY KEY (`viewid`, `userid`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_0900_ai_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of view_user
-- ----------------------------

SET FOREIGN_KEY_CHECKS = 1;
